﻿/**
 * Copyright (C) 2020 by "Infront Financial Technology GmbH" - All Rights Reserved
 *
 * This file is part of/belongs to a project and/or product developed by "Infront Financial Technology GmbH".
 *
 * Unauthorized copying of this file, via any medium is strictly prohibited. Proprietary and
 * confidential. It may not be copied and/or distributed without the express permission of 
 * "Infront Financial Technology GmbH".
 */
using System;
using System.Collections.Generic;
using Gevasys.DataCore.Client;
using Gevasys.DataCore.Core.Protocol;
using Gevasys.DataCore.Core.Protocol.Binary;
using Gevasys.DataCore.Core.Protocol.Binary.Decoding;
using Gevasys.DataCore.RequestData.ProtoBuf.V2;
using Gevasys.DataCore.RequestData.ProtoBuf.V2.Retransmit;
using Gevasys.DataCore.Tools.Protocol;


namespace DataManagerConnect.SampleApplication
{
    class RetransmitSampleClient : RetransmitClient
    {
            private MessageSerializer m_messageSerializer;
            long countUpdates;

            public RetransmitSampleClient(string name): base(name)
            {
                m_messageSerializer = new MessageSerializer();
            }
            public override void ProcessUpdates(List<UpdateMessage> updates)
            {
                foreach (UpdateMessage update in updates)
                {
                    switch (update.MessageType)
                    {
                        case BaseBinaryMessage.MessageType.Proto:
                            //Get the Message ID
                            StringField sf = (StringField)update.GetField(1);
                            if (sf.Value.Equals(MessageIdentifier.RetransmitStatusMessage))
                            {
                                RetransmitStatusMessage statusMessage = ProtobufMessageHelper.DeserializeMessage<RetransmitStatusMessage>(update, ref m_messageSerializer);
                                if (statusMessage != null)
                                {
                                    switch (statusMessage.Status)
                                    {
                                        case RetransmitStatusType.RST_COMPLETED:
                                            //Retransmit completed
                                            Console.WriteLine("Retransmit completed");
                                            break;
                                        case RetransmitStatusType.RST_ERROR:
                                            //Retransmit Error
                                            Console.WriteLine("Retransmit Errror");
                                            Console.WriteLine(statusMessage.StatusMessage);
                                            break;
                                        case RetransmitStatusType.RST_OK:
                                            //Retransmit request accepted.
                                            Console.WriteLine("Retransmit accepted");
                                            break;
                                        case RetransmitStatusType.RST_INPROGRESS:
                                            // Retransmit is in progress.
                                            Console.WriteLine("Retransmit in progress");
                                            break;
                                        case RetransmitStatusType.RST_PARAMSERROR:
                                            //Parameter error in retransmit request
                                            Console.WriteLine(statusMessage.StatusMessage);
                                            break;
                                    }
                                }
                            }
                            break;
                        case BaseBinaryMessage.MessageType.PartialRecap:
                        case BaseBinaryMessage.MessageType.Recap:
                        case BaseBinaryMessage.MessageType.Update:
                            //Process updates
                            break;
                        default:
                            break;
                    }

                    //Writes this update to Console in csv format. Attention: Heavy CPU usage!
                    Console.WriteLine(update.toMachineReadableOutput());
                    //Logger.Log.Info("Retransmit: " + update.toMachineReadableOutput());

                    countUpdates++;
                    if (countUpdates == 1) Console.WriteLine("Retransmit:  updates coming in...");
                    if (countUpdates % 1000 == 0) Console.WriteLine("Retransmit counter: " + countUpdates);

                }
            }    
    }
}


