﻿/**
 * Copyright (C) 2020 by "Infront Financial Technology GmbH" - All Rights Reserved
 *
 * This file is part of/belongs to a project and/or product developed by "Infront Financial Technology GmbH".
 *
 * Unauthorized copying of this file, via any medium is strictly prohibited. Proprietary and
 * confidential. It may not be copied and/or distributed without the express permission of 
 * "Infront Financial Technology GmbH".
 */
using System;
using DataManagerConnect.SampleApplication.Samples.pull;
using Gevasys.DataCore.Configuration;
using Gevasys.DataCore.RequestData.ProtoBuf.V2;
using Gevasys.DataCore.StaticData.Http;

namespace DataManagerConnect.SampleApplication
{
    /// <summary>
    /// This class should illustrate how to use the Data Manager Connect (DMC) library for retrieving static data
    /// and information about financial data in pull fashion
    /// </summary>
    public class SamplePullData
    {
        // Please NOTE: create fields as private
        private MessageSerializer serializer = null;
        private RoutingDataStore rds = null;

        public void GetPullData()
        {
            // Initialization
            serializer = new MessageSerializer();
            rds = ConfigurationHelper.RoutingDataStore;

            // How to use Samples (more examples in folder Samples/pull):

            Console.WriteLine("===============HistoricalTimeSeries (PullData) ==================");
            // 1) create sample to test
            HistoricalTimeSeriesSample historicalDataSample = new HistoricalTimeSeriesSample();
            // 2) call test function using the initialized rds and serializer 
            historicalDataSample.TestHistoricalTimeSeries(rds, serializer);


            Console.WriteLine("===============IsinArbitrage (PullData) ==================");
            IsinArbitrageSample isinArbitrageSample = new IsinArbitrageSample();
            isinArbitrageSample.TestIsinArbitrage(rds, serializer);


            Console.WriteLine("===============QuoteSnapshot (PullData) ==================");
            QuoteSnapshotSample quoteSnapshotSample = new QuoteSnapshotSample();
            quoteSnapshotSample.TestQuoteSnapshot(rds, serializer);


            Console.WriteLine("===============MyVwdCodes (PullData) ==================");
            MyVwdCodesSample myVwdCodesSample = new MyVwdCodesSample();
            myVwdCodesSample.TestMyVwdCodes(rds);

            Console.WriteLine("NOTE: More samples for Pull data can be found in folder Samples/pull...");

            // stop data stores for pull data
            StopPullData();
        }

        // Helper method to stop Routing and/or Static Data Store(s)
        public void StopPullData()
        {
            try
            {
                ConfigurationHelper.RoutingDataStore?.Stop();
            }
            catch (Exception ex)
            {
                Console.WriteLine("Exception while stopping: " + ex.Message);
            }
        }
    }
}
