﻿/**
 * Copyright (C) 2020 by "Infront Financial Technology GmbH" - All Rights Reserved
 *
 * This file is part of/belongs to a project and/or product developed by "Infront Financial Technology GmbH".
 *
 * Unauthorized copying of this file, via any medium is strictly prohibited. Proprietary and
 * confidential. It may not be copied and/or distributed without the express permission of 
 * "Infront Financial Technology GmbH".
 */
using System;
using System.Collections.Generic;
using Gevasys.DataCore.Client;
using Gevasys.DataCore.Core;
using Gevasys.DataCore.Core.Protocol;
using Gevasys.DataCore.Core.Protocol.Binary;
using Gevasys.DataCore.Core.Protocol.Binary.Decoding;
using Gevasys.DataCore.Tools.Protocol;
using Gevasys.DataCore.RequestData.ProtoBuf.V2;

namespace DataManagerConnect.SampleApplication
{
    class SamplePushClient : PushClient
    {
        public SamplePushClient(string name)
              : base(name)
        {
        }

        public override void ProcessUpdates(List<Gevasys.DataCore.Core.Protocol.UpdateMessage> updates)
        {
            foreach (UpdateMessage update in updates)
            {
                switch (update.MessageType)
                {
                    case BaseBinaryMessage.MessageType.Proto:
                        //Get the Message ID
                        StringField sf = (StringField)update.GetField(1);
                        //News
                        if (sf.Value.Equals(MessageIdentifier.NewsMessage))
                        {
                            NewsMessage nm = ProtobufMessageHelper.DeserializeNewsMessage(update);
                        }
                        break;
                    case BaseBinaryMessage.MessageType.PartialRecap:
                    case BaseBinaryMessage.MessageType.Recap:
                    case BaseBinaryMessage.MessageType.Update:
                        ProcessUpdateOrRecap(update);
                        break;
                    case BaseBinaryMessage.MessageType.RequestStatus:
                        if (((RequestStatusMessage)update).Status == RequestStatusType.NotDefined)
                        {
                            Console.WriteLine("Instrument not definied: " + update.GetInstrument());
                        }
                        else if (((RequestStatusMessage)update).Status == RequestStatusType.NoPermission)
                        {
                            Console.WriteLine("No permission for instrument: " + update.GetInstrument());
                        }
                        else if (((RequestStatusMessage)update).Status == RequestStatusType.NotFound)
                        {
                            Console.WriteLine("Instrument not found: " + update.GetInstrument());
                        }
                        else if (((RequestStatusMessage)update).Status == RequestStatusType.ServiceNotAvailable)
                        {
                            Console.WriteLine("Underlying data service is not available");
                        }

                        break;
                    default:
                        break;
                }

                //Attention! Possible heavy CPU usage due console output.
                Console.WriteLine(update.toMachineReadableOutput());
            }
        }

        private void ProcessUpdateOrRecap(UpdateMessage update)
        {
            //Iterate through all field of update
            foreach (BaseField field in update.FieldDict.Values)
            {
                ProcessFieldUpdate(field);
            }

            //And/or
            //Direct access to fields (see vwd Fieldmap.xml)
            BaseField outField = null;
            if (update.TryGetField(80, out outField))
            {
                ProcessFieldUpdate(outField);
            }
        }

        private void ProcessFieldUpdate(BaseField field)
        {
            short fieldId = field.FieldId;
            switch (field.DataTypeValue)
            {
                case BaseBinaryMessage.DataType.String:
                    string stringValue = ((StringField)field).Value;
                    break;
                case BaseBinaryMessage.DataType.DateTime:
                    DateTime timeValue = ((DateTimeField)field).Value;
                    break;
                case BaseBinaryMessage.DataType.Double:
                    double doubleValue = ((DoubleField)field).Value;
                    break;
                case BaseBinaryMessage.DataType.Float:
                    float floatValue = ((FloatField)field).Value;
                    break;
                case BaseBinaryMessage.DataType.Int32:
                    int intValue = ((IntField)field).Value;
                    break;
                case BaseBinaryMessage.DataType.Long:
                    long longValue = ((LongField)field).Value;
                    break;
                case BaseBinaryMessage.DataType.Short:
                    short shortField = ((ShortField)field).Value;
                    break;
            }
        }

        public override void Update(IConsumer source, ConsumerStateChangedEventArgs arg)
        {
            if (arg.IsOnline)
            {
                //Consumer is online. Feed data will be received.
            }
            else
            {
                //Consumer is offline. No feed data will be received.
            }
        }
    }
}
