﻿/**
* Copyright (C) 2020 by "Infront Financial Technology GmbH" - All Rights Reserved
*
* This file is part of/belongs to a project and/or product developed by "Infront Financial Technology GmbH".
*
* Unauthorized copying of this file, via any medium is strictly prohibited. Proprietary and
* confidential. It may not be copied and/or distributed without the express permission of 
* "Infront Financial Technology GmbH".
*/
using System;
using Gevasys.DataCore.Consumer.Manager;
using Gevasys.DataCore.Core;

namespace DataManagerConnect.SampleApplication.Samples.push
{
    /**
     * RecapsSample
     * - subscribe to Recaps for an instruments list using Request Recaps
     */
    public class RecapsSample
    {
        public void TestRequestRecaps(ConsumerStore consumerStore)
        {
            Console.WriteLine("Testing request Recaps...");

            // create instruments list with maximum 1000 instruments
            InstrumentList vwdCodes = new InstrumentList
            {
                "710000.ETR", 
                "BE0389555039"
            };

            // request Recaps to MSC (Market Server Cache)
            consumerStore.RequestRecaps(vwdCodes);
        }    
    }
}