﻿/**
* Copyright (C) 2020 by "Infront Financial Technology GmbH" - All Rights Reserved
*
* This file is part of/belongs to a project and/or product developed by "Infront Financial Technology GmbH".
*
* Unauthorized copying of this file, via any medium is strictly prohibited. Proprietary and
* confidential. It may not be copied and/or distributed without the express permission of 
* "Infront Financial Technology GmbH".
*/
using System;
using System.Linq;
using Gevasys.DataCore.Core;
using Gevasys.DataCore.Core.Logging;
using Gevasys.DataCore.RequestData.ProtoBuf.V2;
using Gevasys.DataCore.StaticData;
using Gevasys.DataCore.StaticData.Http;
using Gevasys.DataCore.Webservice;

namespace DataManagerConnect.SampleApplication.Samples.pull
{
    /**
    * ExchangeSymbolListSample
    * returns all vwd-Codes for given exchange
    */
    public class ExchangeSymbolListSample
    {
        public void TestExchangeSymbolList(RoutingDataStore rds, MessageSerializer serializer)
        {
            // create the request object
            ExchangeSymbolListRequestMessage exchangeSymbolListRequest = new ExchangeSymbolListRequestMessage
            {
                header = new RequestHeaderMessage
                {
                    user = Authentication.GetUser(),
                    password = Authentication.GetPassword()
                },
                exchange = "FFMST"
            };

            // call the DMC backend
            Console.WriteLine("Calling ExchangeSymbolsList function. Please, note that specific permissions might be needed by contract.");
            Console.WriteLine("This might take some time. Waiting until symbols list is displayed...");
            StaticDataResponse response = rds.CallFunction(StaticDataFunctions.EXCHANGE_SYMBOL_LIST,
                InputFormat.PROTO.ToString(),
                OutputFormat.PROTO.ToString(),
                serializer.Serialize<ExchangeSymbolListRequestMessage>(OutputFormat.PROTO, exchangeSymbolListRequest));

            if (response.GetData() == null)
            {
                Logger.Log.Error("There is no data for the request. Error: " + response.GetErrorMessage());
                Logger.Log.Error("Please, inform Infront support to check the server configuration if the error persists.");
                return;
            }

            //get results
            ExchangeSymbolListMessage responseMessage = serializer.Deserialize<ExchangeSymbolListMessage>(InputFormat.PROTO, response.GetData());

            if (responseMessage.header.error_code != ErrorCodes.Ok)
            {
                Logger.Log.Warn("Error: " + responseMessage.header.error_message);
                Logger.Log.Warn("Error getting response data. Please, check if requested data is correct or if you are missing permissions to use this function.");
                return;
            }

            //Takes 20 symbols and prints results
            WriteResultsToConsole(responseMessage);
        }

        private static void WriteResultsToConsole(ExchangeSymbolListMessage responseMessage)
        {
            // get results and print
            InstrumentList symbolList = new InstrumentList();
            symbolList.AddRange(responseMessage.symbols);
            Console.WriteLine("StaticdataStore: TEST list of first 20 from " + symbolList.Count + " active symbols at: FFMST");
            foreach (string symbol in symbolList.Take(20))
            {
               Console.WriteLine("active symbol:" + symbol);
            }
        }
    }
}
