﻿/**
* Copyright (C) 2020 by "Infront Financial Technology GmbH" - All Rights Reserved
*
* This file is part of/belongs to a project and/or product developed by "Infront Financial Technology GmbH".
*
* Unauthorized copying of this file, via any medium is strictly prohibited. Proprietary and
* confidential. It may not be copied and/or distributed without the express permission of 
* "Infront Financial Technology GmbH".
*/
using System;
using Gevasys.DataCore.Core.Logging;
using Gevasys.DataCore.RequestData.ProtoBuf.V2;
using Gevasys.DataCore.StaticData;
using Gevasys.DataCore.StaticData.Http;
using Gevasys.DataCore.Webservice;


namespace DataManagerConnect.SampleApplication.Samples.pull
{
    /**
    * FieldMapSample
    * returns all fieldmap fields by ID, Name and Description
    */
    public class FieldMapSample
    {
        public void TestFieldMap(RoutingDataStore rds, MessageSerializer serializer)
        {
            // create the request object
            FieldMapRequestMessage requestMessage = new FieldMapRequestMessage
            {
                header = new RequestHeaderMessage
                {
                    user = Authentication.GetUser(),
                    password = Authentication.GetPassword()
                }
            };

            // call the DMC backend
            Console.WriteLine("Calling FieldMap function. Please, note that specific permissions might be needed by contract.");
            StaticDataResponse response = rds.CallFunction(StaticDataFunctions.FIELDMAP,
                InputFormat.PROTO.ToString(),
                OutputFormat.PROTO.ToString(),
                serializer.Serialize<FieldMapRequestMessage>(OutputFormat.PROTO, requestMessage));

            if (response.GetData() == null)
            {
                Logger.Log.Error("There is no data for the request. Error: " + response.GetErrorMessage());
                Logger.Log.Error("Please, inform Infront support to check the server configuration if the error persists.");
                return;
            }

            //get results
            FieldMapMessage responseMessage = serializer.Deserialize<FieldMapMessage>(InputFormat.PROTO, response.GetData());

            if (responseMessage.header.error_code != ErrorCodes.Ok)
            {
                Logger.Log.Warn("Error: " + responseMessage.header.error_message);
                Logger.Log.Warn("Error getting response data. Please, check if requested data is correct or if you are missing permissions to use this function.");
                return;
            }

            WriteResultsToConsole(responseMessage);
        }

        private static void WriteResultsToConsole(FieldMapMessage responseMessage)
        {
            Console.WriteLine("List of all fieldmap fields by ID, Name and Description:");
            foreach (FieldMapEntryMessage field in responseMessage.fields)
            {
                Console.WriteLine("name (DE): " + field.name);
                Console.WriteLine("fieldId: " + field.fieldId);
                Console.WriteLine("dataType: " + field.dataType);
                Console.WriteLine("nameShort (EN): " + field.nameShort);
                Console.WriteLine("nameLong (EN): " + field.nameLong);
                Console.WriteLine("description (EN): " + field.description);
                Console.WriteLine("\r");
            }
        }
    }
}
