﻿/**
* Copyright (C) 2020 by "Infront Financial Technology GmbH" - All Rights Reserved
*
* This file is part of/belongs to a project and/or product developed by "Infront Financial Technology GmbH".
*
* Unauthorized copying of this file, via any medium is strictly prohibited. Proprietary and
* confidential. It may not be copied and/or distributed without the express permission of 
* "Infront Financial Technology GmbH".
*/
using System;
using System.IO;
using System.Threading;
using DataManagerConnect.SampleApplication.Samples.push;
using Gevasys.DataCore.Configuration;
using Gevasys.DataCore.Consumer.Manager;


namespace DataManagerConnect.SampleApplication
{
    /// <summary>
    /// This class should illustrate the usage of the Data Manager Connect (DMC) library for streaming push data
    /// 
    /// NOTE: This might not work for you if your contract does not include realtime push data!
    ///       If unsure, please contact your sales responsitive
    /// </summary>
    public class SamplePushData
    {
        // Please NOTE: create fields as private for Push Data
        private ConsumerStore consumerStore = null;
        private SamplePushClient pushClient = null;

        public void GetStreamingData()
        {
            // Initialization
            pushClient = new SamplePushClient("Sample");
            pushClient.Start();
            consumerStore = ConfigurationHelper.CreateConsumer(pushClient);

            // Test Samples:

            // ================== TestStreamingData =======================================
            Console.WriteLine("===============StreamingData - SingleInstrument (PushData) ==================");
            SingleInstrumentSample singleInstrumentSample = new SingleInstrumentSample();
            singleInstrumentSample.TestStreamingDataSingleInstrument(consumerStore);

            // subscribe instruments included in text file "SampleInstruments.txt" (Data folder)
            var instrumentsFileName = Path.Combine(Environment.CurrentDirectory, "../../Data", "SampleInstruments.txt");
            singleInstrumentSample.TestStreamingDataByTextFile(consumerStore, instrumentsFileName);

            // NOTE: This might not work for you if your contract does not include MFFG and realtime data!
            // If unsure, please contact your sales responsitive
            Console.WriteLine("===============StreamingData - WholeExchange (PushData) ==================");
            WholeExchangeSample exchangeSample = new WholeExchangeSample();
            exchangeSample.TestStreamingDataWholeExchange(consumerStore);

            // === More test examples provided in folder "Samples/push" ===

            // Wait 60 seconds and stop
            Thread.Sleep(60000);
            StopStreaming();
        }

        // Helper method to stop streaming data store and push client
        public void StopStreaming()
        {
            if (consumerStore != null)
            {
                Console.WriteLine("Stopping consumerStore...");
                consumerStore.Stop();

                // Waiting to give consumerStore time to stop
                Thread.Sleep(3000);

                Console.WriteLine("Stopping pushClient sample...");
                pushClient.Stop();
            }
        }
    }
}

