﻿/**
* Copyright (C) 2020 by "Infront Financial Technology GmbH" - All Rights Reserved
*
* This file is part of/belongs to a project and/or product developed by "Infront Financial Technology GmbH".
*
* Unauthorized copying of this file, via any medium is strictly prohibited. Proprietary and
* confidential. It may not be copied and/or distributed without the express permission of 
* "Infront Financial Technology GmbH".
*/
using System;
using System.Collections.Generic;
using System.IO;
using Gevasys.DataCore.Consumer.Manager;
using Gevasys.DataCore.Core;

namespace DataManagerConnect.SampleApplication.Samples.push
{
    /**
     * SingleInstrumentSample
     * - subscribe to instruments using single instrument, lists or text file using streaming data (push data)
     * - unsubscribe from instruments
     */
    public class SingleInstrumentSample
    {
        public void TestStreamingDataSingleInstrument(ConsumerStore consumerStore)
        {
            Console.WriteLine("Testing subscribe single instruments...");
            consumerStore.AddInstrument("555750.ETR");
        }

        public void TestStreamingDataInstrumentList(ConsumerStore consumerStore)
        {
            //Add instruments list
            InstrumentList instruments =
                new InstrumentList(new List<string> { "710000.ETR", "BE0389555039" });
            consumerStore.AddInstruments(instruments);
        }

        public void TestStreamingDataByTextFile(ConsumerStore consumerStore, string instrumentsFileName)
        {
            InstrumentList instruments = new InstrumentList();
            instruments.AppendFromFile(instrumentsFileName);
            consumerStore.AddInstruments(instruments);
        }

        public void TestRemoveIstrument(ConsumerStore consumerStore)
        {
            consumerStore.RemoveInstrument("555750.ETR");
        }

        public void TestRemoveIstruments(ConsumerStore consumerStore)
        {
            InstrumentList instruments =
                new InstrumentList(new List<string> { "710000.ETR", "BE0389555039" });
            consumerStore.RemoveInstruments(instruments);
        }
    }
}