﻿/**
 * Copyright (C) 2020 by "Infront Financial Technology GmbH" - All Rights Reserved
 *
 * This file is part of/belongs to a project and/or product developed by "Infront Financial Technology GmbH".
 *
 * Unauthorized copying of this file, via any medium is strictly prohibited. Proprietary and
 * confidential. It may not be copied and/or distributed without the express permission of 
 * "Infront Financial Technology GmbH".
 */
using System;
using System.IO;
using Gevasys.DataCore.Configuration;
using Gevasys.DataCore.Core.Logging;


namespace DataManagerConnect.SampleApplication
{
    class Sample
    {
        /// <summary>
        /// Main entry point
        /// </summary>
        /// <param name="args"></param>
        public static void Main(string[] args)
        {
            // Remove this block if you have properly configured your application.

            Console.WriteLine("*** Please change settings in App.config with the correct login values provided to you *** ");
            Console.WriteLine("After setting them, remove this warning from Sample.cs, method Main (line 29).");
            Console.WriteLine("This is to prevent that you do not run into problems when started without proper configuration.");
            Console.ReadLine();
            return;


            Sample dmcClientSample = new Sample();
            if (!dmcClientSample.Initialize())
                return;

            dmcClientSample.Start();

            Console.WriteLine("Press any key to exit ...");
            Console.ReadKey();
        }

        /// <summary>
        /// Initialize the Data Manager Connect (DMC) library
        /// Note that DMC configuration is taken from App.config via .NET configuration mechanism
        /// </summary>
        /// <returns></returns>
        public bool Initialize()
        {
            //Initialize the logging system (hint the log4net configuration file 'log_config.xml')
            string logConfigFilePath = Path.Combine(Environment.CurrentDirectory, "Configuration");
            Logger.Initialise(logConfigFilePath, "BaseLogger", "log_config.xml");

            //Read the configuration from App.config
            if (!ConfigurationHelper.Initialize())
            {
                Logger.Log.Error("Failed to initialize DMC library! Please check logfiles and your configuration!");
                Console.WriteLine("Failed to initialize DMC library! Either wrong credentials or perhaps network connectivity problems.");
                return false;
            }

            // Everything successfully initialized, we're ready to work with DMC
            return true;
        }            

        public void Start()
        {
            // ************************** PULL DATA *****************************************//
            // * Examples to test Pull Data (static data) can be found in "SamplePullData()"
            // * More samples can be found in the folder 'samples/pull'
            // ******************************************************************************//

            Console.WriteLine("======= Testing Pull Data samples (Static Data - RoutingDataStore) ==========");
            new SamplePullData().GetPullData();

            //  ************************* PUSH DATA (Streaming)  ***********************************************//
            // * Examples to test Push Data (streaming) can be found in "SamplePushData()"
            // * More samples can be found in the folder 'samples/push'
            // * Please uncomment the following code only if you are sure that you are licensed for Streaming Data
            // **************************************************************************************************//

            //// NOTE: Uncomment these 2 lines ONLY if your contract include realtime push data!
            //Console.WriteLine("======= Testing Push Data samples (Streaming - ConsumerStore) ==========");
            //new SamplePushData().GetStreamingData();

            //********************* RETRANSMIT DATA *********************************************//
            // * RetransmitDataSample available in Samples - "retransmit" folder
            // **********************************************************************************//

            Console.WriteLine("Finished!");
        }
    }
}