﻿/**
* Copyright (C) 2020 by "Infront Financial Technology GmbH" - All Rights Reserved
*
* This file is part of/belongs to a project and/or product developed by "Infront Financial Technology GmbH".
*
* Unauthorized copying of this file, via any medium is strictly prohibited. Proprietary and
* confidential. It may not be copied and/or distributed without the express permission of 
* "Infront Financial Technology GmbH".
*/
using System;
using System.Collections.Generic;
using Gevasys.DataCore.StaticData.Http;
using Gevasys.DataCore.StaticData.MyVwdCodesHelper;


namespace DataManagerConnect.SampleApplication.Samples.pull
{
    /**
    * MarketSnapshotSample (using MyVwdCodesHelper)
	* GetMyVwdCodesCount() -> returns all VwdCodes where the user is permissioned for
	* GetMyVwdCodes(int pageNumber, int codesPerPage) -> returns the vwdCodes by using paging
	* GetMyVwdCodesCountByExchange(String exchange) -> returns all VwdCodes for the given exchange where the user is permissioned for
	* GetMyVwdCodesByExchange(String exchange, int pageNumber, int codesPerPage) -> returns the vwdCodes for the given exchange by using paging
	* GetMyVwdCodesByExchange(List<string> exchanges)
	* GetMyExchanges()		 
	*/
    public class MyVwdCodesSample
    {
        public void TestMyVwdCodes(RoutingDataStore rds)
        {            
            MyVwdCodesHelper myVwdCodesHelper = new MyVwdCodesHelper(rds);

            if (myVwdCodesHelper != null)
            {
                // test GetMyVwdCodesCount -> returns all VwdCodes where the user is permissioned for
                int myVwdCodesCount = myVwdCodesHelper.GetMyVwdCodesCount();
                Console.WriteLine("Permission for " + myVwdCodesCount + " vwdCodes.");

                // test GetMyVwdCodes(int pageNumber, int codesPerPage)->returns the vwdCodes by using paging
                List<string> vwdCodes = myVwdCodesHelper.GetMyVwdCodes(1, 100);
                Console.WriteLine("List of 100 permissioned instruments(vwdCodes):");
                foreach (string vwdCode in vwdCodes)
                {
                    Console.WriteLine(vwdCode);
                }

                // test GetMyVwdCodesByExchange(String exchange, int pageNumber, int codesPerPage) -> returns the vwdCodes for the given exchange by using paging
                string exchange = "ETR";
                List<string> codeListByExchange = myVwdCodesHelper.GetMyVwdCodesByExchange(exchange, 1, 100);
                Console.WriteLine("List of 100 authorized instruments(vwdCodes) by exchange: " + exchange);
                foreach (string vwdCode in codeListByExchange)
                {
                    Console.WriteLine(vwdCode);
                }
            }
        }
    }
}
