﻿/**
* Copyright (C) 2020 by "Infront Financial Technology GmbH" - All Rights Reserved
*
* This file is part of/belongs to a project and/or product developed by "Infront Financial Technology GmbH".
*
* Unauthorized copying of this file, via any medium is strictly prohibited. Proprietary and
* confidential. It may not be copied and/or distributed without the express permission of 
* "Infront Financial Technology GmbH".
*/
using System;
using System.Collections.Generic;
using Gevasys.DataCore.Core.Logging;
using Gevasys.DataCore.RequestData.ProtoBuf.V2;
using Gevasys.DataCore.StaticData;
using Gevasys.DataCore.Webservice;
using Gevasys.DataCore.RequestData.ProtoBuf.V2.OptionsMatrix;
using Gevasys.DataCore.StaticData.Http;

namespace DataManagerConnect.SampleApplication.Samples.pull
{
    /** OptionMatrixSample
    *  returns the option matrix for a specified vwdCode.
    **/
    public class OptionMatrixSample
    {
        public void TestOptionMatrix(RoutingDataStore rds, MessageSerializer serializer)
        { 
            // create object request
            OptionsMatrixRequestMessage requestMessage = new OptionsMatrixRequestMessage
            {
                header = new RequestHeaderMessage()
                {
                    user = Authentication.GetUser(),
                    password = Authentication.GetPassword()
                },
                vwdCode = "555750.ETR",
                eurexOnly = true            
            };

            // call DMC backend
            Console.WriteLine("Calling OptionsMatrix function. Please, note that specific permissions might be needed by contract.");
            StaticDataResponse response = rds.CallFunction(StaticDataFunctions.OPTIONS_MATRIX, 
                InputFormat.PROTO.ToString(), 
                OutputFormat.PROTO.ToString(),
                serializer.Serialize<OptionsMatrixRequestMessage>(OutputFormat.PROTO, requestMessage));

            if (response.GetData() == null)
            {
                Logger.Log.Error("There is no data for the request. Error: " + response.GetErrorMessage());
                Logger.Log.Error("Please, inform Infront support to check the server configuration if the error persists.");
                return;
            }

            //get results
            OptionsMatrixListMessage responseMessage = serializer.Deserialize<OptionsMatrixListMessage>(InputFormat.PROTO, response.GetData());

            if (responseMessage.header.error_code != ErrorCodes.Ok)
            {
                Logger.Log.Warn("Error: " + responseMessage.header.error_message);
                Logger.Log.Warn("Error getting response data. Please, check if requested data is correct or if you are missing permissions to use this function.");
                return;
            }
           
            Logger.Log.Info("RoutingDataStore response for OptionsMatrixRequestMessage for vwdCode: " + requestMessage.vwdCode);           
           
            WriteOptionsMatrixListMessage(responseMessage);
        }

        private void WriteOptionsMatrixListMessage(OptionsMatrixListMessage optionsMatrixListMessage)
        {
            List<OptionsMatrixMessage> options = optionsMatrixListMessage.options;
            if (options == null) {
                Console.WriteLine("No Options to write on console");
                Logger.Log.Warn("No Options to write on console");
            }
            Console.WriteLine(options.Count + " options found for vwdCode 555750.ETR");
           foreach(OptionsMatrixMessage optionsMatrixMessage in options)
            {
                Console.WriteLine("---------------------------------");
                Console.WriteLine("VwdCode: "+optionsMatrixMessage.vwdCode);
                Console.WriteLine("exchangeCodeVwd: " + optionsMatrixMessage.exchangeCodeVwd);
                Console.WriteLine("exercise: " + optionsMatrixMessage.exercise);
                Console.WriteLine("expirationDate: " + optionsMatrixMessage.expirationDate);
                Console.WriteLine("iso4217Currency: " + optionsMatrixMessage.iso4217Currency);
                Console.WriteLine("optionCategory: " + optionsMatrixMessage.optionCategory);
                Console.WriteLine("optionType:" + optionsMatrixMessage.optionType);
                Console.WriteLine("strike: " + optionsMatrixMessage.strike);
            }
        }
    }
}
